#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;
attribute vec4 inTexCoord1;

varying	vec3 lightVector, halfVector, lightVector2;
varying vec2 vTexCoord;
varying vec4 shadowCoord;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;
in vec4 inTexCoord1;

out	vec3 lightVector, halfVector, lightVector2;
out vec2 vTexCoord;
out vec4 shadowCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelViewMatrixInverse;
uniform mat4 shadowMatrix;

uniform vec3 lightSource1;
uniform vec3 lightSource1HV;
uniform vec3 lightSource2;
uniform vec3 lightSource2HV;

void main()
{
	vec3 vTangent = inTexCoord1.xyz;
	vec3 vBitangent = cross(inNormal, vTangent) * inTexCoord1.w;
	mat3 mvmi;
	mvmi[0] = modelViewMatrixInverse[0].xyz;
	mvmi[1] = modelViewMatrixInverse[1].xyz;
	mvmi[2] = modelViewMatrixInverse[2].xyz;

	vec3 lV = mvmi * lightSource1;
	vec3 hV = mvmi * normalize(lightSource1HV + lightSource2HV);
	vec3 l2V = mvmi * lightSource2;

	lightVector.x = dot(vTangent, lV);
	lightVector.y = dot(vBitangent, lV);
	lightVector.z = dot(inNormal, lV);

	lightVector2.x = dot(vTangent, l2V);
	lightVector2.y = dot(vBitangent, l2V);
	lightVector2.z = dot(inNormal, l2V);

	halfVector.x = dot(vTangent, hV);
	halfVector.y = dot(vBitangent, hV);
	halfVector.z = dot(inNormal, hV);

	vec4 fourInVertex = vec4(inVertex, 1.0);
	
	shadowCoord = shadowMatrix * fourInVertex;
	
	vTexCoord = inTexCoord0;
	gl_Position = projectionMatrix * modelViewMatrix * fourInVertex;
}
